<?php

return [
    'required' => __('The :attribute field is required.'),
    'email' => __('The :attribute must be a valid email address.'),
    'unique' => __('The :attribute has already been taken.'),
    'image' => __('The :attribute must be an image.'),
    'dimensions' => __('The :attribute has invalid image dimensions.'),
    'confirmed' => __('The :attribute confirmation does not match.'),
    'numeric' => __('The :attribute must be a number.'),
    'string' => __('The :attribute must be a string.'),
    'boolean' => __('The :attribute field must be true or false.'),
    'exists' => __('The selected :attribute is invalid.'),
    'required_if' => __('The :attribute field is required when :other is :value.'),
    'url' => __('The :attribute format is invalid.'),
    'array' => __('The :attribute must be an array'),
    'mimes' => __('The :attribute must be a file of type :values.'),
    'file' => __('The :attribute must be a file.'),

    'max' => [
        'numeric' => __('The :attribute may not be greater than :max.'),
        'file' => __('The :attribute may not be greater than :max kilobytes.'),
        'string' => __('The :attribute may not be greater than :max characters.'),
        'array' => __('The :attribute may not have more than :max items.'),
    ],
    'min' => [
        'numeric' => __('The :attribute must be at least :min.'),
        'file' => __('The :attribute must be at least :min kilobytes.'),
        'string' => __('The :attribute must be at least :min characters.'),
        'array' => __('The :attribute must have at least :min items.'),
    ],
    'attributes' => [
        'name' => __('name'),
        'avatar' => __('avatar'),
        'email' => __('email'),
        'current_password' => __('Current password'),
        'password' => __('password'),
        'title' => __('title'),
        'required_time' => __('required time'),
        'cost' => __('cost'),
        'price' => __('price'),
        'model' => __('model'),
        'locale' => __('locale'),
        'value' => __('value'),
        'extra_charge' => __('extra charge'),
        'body' => __('body'),
        'phone' => __('phone'),
        'address' => __('address'),
        'icon' => __('app icon'),
        'background' => __('app background'),
        'app_user_registration' => __('user registration'),
        'app_default_role' => __('default role'),
        'recaptcha_enabled' => __('recaptcha enabled'),
        'recaptcha_public' => __('recaptcha public'),
        'recaptcha_private' => __('recaptcha private'),
        'currency_symbol' => __('currency symbol'),
        'app_url' => __('app url'),
        'app_address' => __('address'),
        'app_phone' => __('phone'),
        'app_name' => __('name'),
        'app_https' => __('is https'),
        'app_timezone' => __('timezone'),
        'app_about' => __('about'),
        'app_locale' => __('locale'),
        'app_date_locale' => __('date locale'),
        'app_date_format' => __('date format'),
        'mail_from_address' => __('from address'),
        'mail_from_name' => __('from name'),
        'mail_host' => __('outgoing mail host'),
        'mail_port' => __('outgoing mail port'),
        'mail_username' => __('outgoing mail username'),
        'mail_password' => __('outgoing mail password'),
        'mailgun_domain' => __('mailgun domain'),
        'mailgun_secret' => __('mailgun secret'),
        'mailgun_endpoint' => __('mailgun endpoint'),
        'meta_home_title' => __('home title'),
        'meta_keywords' => __('keywords'),
        'meta_description' => __('description'),
        'tax_rate' => __('tax rate'),
        'permissions' => __('permissions'),
        'status' => __('status'),
        'role_id' => __('role'),
        'file' => __('file'),
        'token' => __('token'),
        'is_device_collected' => __('device collected'),
        'query_status_id' => __('query status'),
        'user_id' => __('user'),
        'status_id' => 'status',
    ],

];
